//  -*- Mode: C++;  -*-

//  File: arc2surf.cpp

//  Author: Dino Bellugi (dino@geomorph.berkeley.edu)

//  Copyright  Dino Bellugi, BlueG SoftWear, U.C. Berkeley, 1999 (C)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// * FUNCTION: Converts from arcinfo to surfer formats

// * 

// * RELATED PACKAGES: grid.cpp stabfun.cpp

// *

// * HISTORY:

// * Created:  Thu Mar 27 1997 (dino)

// * Modified: Mon May 10 1999 (dino)

// *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



// the following include file (notice.h) contains important copyright 

// information, as well as other legal statements. it must be present 

// in all files and in any distribution. removal or modification is

// strictly forbidden and violates u.s. and international copyright law.

#include "notice.h"

char *copyright_notice = "(C) 1999 Dino Bellugi, BlueG SoftWear, U.C. Berkeley";

//


#include "stabfun.h"



#define INPUT		0

#define OUTPUT		1

#define MESSAGES	1



main(int argc, char **argv) 

{

	Grid grd;

	int i, j;

	double val, minz = 10.0e+100, maxz = -10.0e+100;



	if (argc != 2) 

	{

#if (MESSAGES)

                // invalid arguments, print usage

                cerr << "usage:\n";

                cerr << "\t" << appName(argv) << " <input grid>\n";

                cerr << "example:\n";

                cerr << "\t" << appName(argv) << " arcinfo.grd > surfer.grd\n";

#endif



    		exit(1);

  	}



#if (MESSAGES)

	cerr << "Reading input arcinfo grid ...\n";

#endif



	if (!grd.readGrid(argv[1], INPUT, ARCINFO))

		exit(1);



#if (MESSAGES)

	cerr << "Changing nodata value (" << grd.nodata << " to " <<

		SURF_VAL << ") ...\n";

#endif



	grd.chgNodata(SURF_VAL, TRUE, INPUT);



#if (MESSAGES)

        cerr << "Initializing output grid ...\n";

#endif



        if (!grd.addField())

                exit(1);



#if (MESSAGES)

	cerr << "Converting grid (" << grd.ydim << " rows, " << grd.xdim <<

		" columns) ...\n";

#endif



	for (i = 0; i < grd.xdim; ++i)

	{

		for (j = 0; j < grd.ydim; ++j)

		{

			val = grd.at(i, j, OUTPUT) = 

				grd.at(i, grd.ydim - j - 1, INPUT);

			if (val != grd.nodata && val < minz)

				minz = val;

			if (val != grd.nodata && val > maxz)

				maxz = val;

		}

	}  



#if (MESSAGES)

	cerr << "min: " << minz << ", max: " << maxz << "\n";

	cerr << "Writing output surfer grid ...\n";

#endif

	grd.coutGrid(OUTPUT, SURFER, minz, maxz);



        exit(FALSE);    

        return(TRUE);

}

